# How to contribute changes

The following is a set of guidelines for proposing changes to the
Belenios open-source distribution. These are just guidelines, not
rules, use your best judgment and feel free to propose changes to this
document itself in a pull request.

This document assumes that you have a patch against the sources of
Belenios, that you wish to submit to the Belenios maintainers
upstream. See [INSTALL.md](INSTALL.md) for details on how to build
Belenios from sources.

## Contribution

Modifying the sources is far from the only way to contribute to
Belenios. Bug reports (in particular when they come with a
reproducible example), simple typos or clarifications in the
documentation also help, and help evaluating and integrating existing
change proposals also help. Providing good answers on the discussion
forums, or asking the good questions that highlight deficiencies in
existing documentations, also help.

There are also many valuable ways to contribute to the wider Belenios
ecosystem that do not involve changes to Belenios.

The rest of the document is concerned with the form of change
proposals against Belenios. (Code changes, but also improvement to
documentation or implementation comments, which are valuable changes
on their own.)

## Workflow

All changes to translations should be done using
[Weblate](https://hosted.weblate.org/projects/belenios/).

Other kinds of source changes must be submitted directly to the
maintainers, preferably through a GitHub Pull Request against the
[Belenios](https://github.com/glondu/belenios) project.

### Maintainers

The current list of maintainers is as follows:

- @glondu Stéphane Glondu (VCAST, Inria)

## Contributor License Agreement

We distinguish two kinds of contributions:

- Small changes that do not bear a specific mark of their authors
  (another developer recreating the change without access to the
  original patch would write an indistinguishable patch), and are thus
  not protected by copyright, do not require any particular
  paperwork. This is convenient for everyone, and of course does not
  mean that those contributions are of lesser importance. (For example
  a bugfix can be obvious once a bug is understood, reported and
  reproduced, and yet invaluable for users.)

- Larger changes that are covered by copyright. For them, we require
  contributors to sign a Contributor License Agreement (CLA), which
  gives [VCAST](https://www.vcast.vote/) the rights to integrate the
  contribution, maintain it, evolve it, and redistribute it under the
  license of its choice. This is not a copyright *assignment* (as
  requested by the Free Software Foundation for example), contributors
  retain the copyright on their contribution, and can use it as they
  see fit. The Belenios CLA is lightly adapted from [the
  CLA](https://apache.org/licenses/icla.pdf) of the Apache Foundation,
  and is available in two versions: for individual contributors and
  for corporations.

You must understand that, by proposing a contribution for integration
in the Belenios open-source distribution, you accept that it be
considered under one of those regimes. In particular, in all cases,
you give VCAST the permission to freely re-license the Belenios
open-source distribution including the contribution.

### How to sign the CLA

If your contribution is large enough, you should sign the CLA. If you
are contributing on your own behalf, you should sign the individual
CLA. For corporate contributions, if your employer has not already
done so, they should sign the corporate CLA. Please contact Stéphane
Glondu to get more information.
